#pragma once

#include <internal/storage/service.h>
#include <mail_getter/attachment_storage.h>

namespace mail_getter {

class AttachmentStorageImpl : public AttachmentStorage {
public:
    using MetaInfo = AttachmentStorage::MetaInfo;
    using VectorOfAttachments = AttachmentStorage::VectorOfAttachments;

    int add(const AbstractAttachment& attachment, std::string& id, MetaInfo& metaInformation,
        std::chrono::seconds expireTimeout, std::chrono::seconds shieldTimeout, const attach_sid::Keys& keys,
        OptYieldContext yc) override;
    int get(const std::vector<std::string>& ids, VectorOfAttachments& result, OptYieldContext yc) override;

    AttachmentStorageImpl(storage::ServicePtr storage, const std::string& webAttachHost)
            : storage_(std::move(storage)), webAttachHost_(webAttachHost) {
        if (!storage_) {
            throw std::invalid_argument(std::string(__PRETTY_FUNCTION__) + ": need mail storage service");
        }
    }

private:
    storage::ServicePtr storage_;
    std::string webAttachHost_;
};

} // namespace mail_getter
