#ifndef MAIL_GETTER_INLINE_MESSAGES_H
#define MAIL_GETTER_INLINE_MESSAGES_H

#include <mail_getter/MessageAccessDefinitions.h>
#include <internal/MessageStorage.h>
#include <unordered_map>

namespace mail_getter {

using InlineMessages = std::unordered_map<std::string, MessageStoragePtr>;

inline InlineMessages getInlineMessages(const MetaParts& metaParts) {
    InlineMessages res;
    for (const auto& v : metaParts) {
        const auto& mp = v.second;
        if (mp.contentType() == "message" && mp.contentSubtype() == "rfc822" && !mp.hid().empty()) {
            res.emplace(mp.hid(), nullptr);
        }
    }
    return res;
}

}  // namespace mail_getter

#endif // MAIL_GETTER_INLINE_MESSAGES_H
