#pragma once

#include <mail_getter/MessageAccess.h>
#include <internal/MessageStorage.h>

namespace mail_getter {

class MessageAccessImpl: public MessageAccess {
public:
    MessageAccessImpl(const std::string &stId, MessageStoragePtr storage,
        OptYieldContext yc);

    MessageAccessImpl(MessageAccessImpl&&) = default;

    MetaPart getHeaderStruct(const std::string &hid) override;
    MetaLevel getBodyStruct(const std::string &hid) override;
    std::string getHeader(const std::string &hid) override;
    std::string getBody(const std::string &hid) override;
    std::string getWhole() override;

    /**
     * @return storage id.
     */
    const std::string& getStId() const override;
    /**
     * @return not "header field per line", but already parsed and
     * concatenated header fields via HeaderParser
     */
    MetaAttributes getMessageHeaderParsed(const std::string &hid) override;

private:
    std::string stid;
    MessageStoragePtr storage_;
    OptYieldContext yc_;

    MessageStoragePtr& storage() {
        if (!storage_) {
            throw std::invalid_argument(std::string(__PRETTY_FUNCTION__) + ": need storage");
        }
        return storage_;
    }
};

}
