#pragma once

#include <mail_getter/meta_parts_converter.h>
#include <mail_getter/recognizerWrapper.h>
#include <internal/storage/service.h>

namespace mail_getter {

class MetaPartsConverterImpl: public MetaPartsConverter {
public:
    MetaPartsConverterImpl(storage::ServicePtr storageService, const Recognizer::Wrapper& recognizer)
        : storageService_(storageService),
          recognizer(&recognizer)
    {}
    MetaParts getMetaPartsFromXml(const Stid& stid, OptYieldContext yc) const override;
    MetaParts extractMetaPartsFromInline(MessageAccessPtr messageAccess,
        const MetaPart& inlineMessagePart, OptYieldContext yc) const override;
private:
    storage::ServicePtr storageService_;
    const Recognizer::Wrapper* recognizer;
};

}
