#pragma once

#include <pa/async.h>

namespace mail_getter {

class PaLog {
public:
    using Clock = std::chrono::steady_clock;

    PaLog(pa::rem_type type, std::string host, std::string method, std::string id)
        : type(type), host(std::move(host)), method(std::move(method)), id(std::move(id)) {}

    void operator ()() const {
        using std::chrono::milliseconds;
        using std::chrono::duration_cast;
        const auto duration = duration_cast<milliseconds>(Clock::now() - start).count();
        pa::async_profiler::add(type, host, method, id, std::uint32_t(duration));
    }

private:
    pa::rem_type type;
    std::string host;
    std::string method;
    std::string id;
    Clock::time_point start = Clock::now();
};

} // namespace mail_getter
