#pragma once

#include <mail_getter/service.h>
#include <mail_getter/mulcagate/mulcagate_client.h>
#include <internal/MessageStorage.h>
#include <internal/storage/service.h>

namespace mail_getter {

class ServiceImpl : public Service {
public:
    ServiceImpl(mulcagate::SettingsPtr settings, logging::LogPtr logger,
            storage::ServicePtr storageService)
            : settings(std::move(settings)),  logger(std::move(logger)),
              storageService(std::move(storageService)) {
    }

    MessageAccessPtr createMessageAccess(MessageAccessParams params,  const Recognizer::Wrapper& recognizer,
                                         OptYieldContext yc) const override;
    MessageAccessPtr createMessageAccess(MessageAccessWithWindatParams params, const Recognizer::Wrapper& recognizer,
            OptYieldContext yc = boost::none) const override;
    AttachmentStoragePtr createAttachmentStorage(const std::string& webAttachHost) const override;
    MetaPartsConverterPtr createMetaPartsConverter(const Recognizer::Wrapper& recognizer) const override;

private:
    mulcagate::SettingsPtr settings;
    logging::LogPtr logger;
    storage::ServicePtr storageService;

    MessageStoragePtr createMessageStorage(MessageAccessParams params, const Recognizer::Wrapper& recognizer,
                                           OptYieldContext yc) const;
    bool needBlobStorage(const Stid& stid) const;
    bool useMimes(const MetaParts& metaParts) const;
};

}  // namespace mail_getter
