#ifndef MAIL_GETTER_STID_PARSERS_H
#define MAIL_GETTER_STID_PARSERS_H

#include <string>
#include <algorithm>
#include <boost/optional.hpp>

namespace mail_getter {

const std::string tmpStorageServiceId = "tmp";

inline boost::optional<std::string> extractServiceId(const std::string& stId) {
    auto lpos = stId.find('.');
    if (lpos == std::string::npos) {
        return boost::none;
    }
    auto rpos = stId.find('.', ++lpos);
    if (rpos == std::string::npos) {
        return boost::none;
    }
    rpos = std::min(rpos, stId.find(':', lpos));
    return stId.substr(lpos, rpos - lpos);
}

}  // namespace mail_getter

#endif // MAIL_GETTER_STID_PARSERS_H
