#ifndef MAIL_GETTER_STORAGE_MULCAGATE_SERVICE_H
#define MAIL_GETTER_STORAGE_MULCAGATE_SERVICE_H

#include <internal/storage/service.h>
#include <mail_getter/mulcagate/mulcagate_client.h>

namespace mail_getter {
namespace storage {

class MulcagateService : public Service {
public:
    MulcagateService(mulcagate::MulcagateClientPtr client) : mulcagateClient(std::move(client)) {}

    void asyncGetBlob(const Stid& stid, OnGetBlob handler) const override;
    void asyncPutBlob(const std::string& baseId, const std::string& data, std::chrono::seconds ttl,
            OnPutBlob handler) const override;
    void asyncGetXml(const Stid& stid, OnGetXml handler) const override;
    void asyncGetByRange(const Stid& stid, const Range& range, OnGetBlob handler) const override;

private:
    mulcagate::MulcagateClientPtr mulcagateClient;
};

}  // namespace storage
}  // namespace mail_getter

#endif // MAIL_GETTER_STORAGE_MULCAGATE_SERVICE_H
