#pragma once

#include <internal/storage/service.h>
#include <mail_getter/mulcagate/mulcagate_client.h>

namespace mail_getter {
namespace storage {

class ServiceFactory {
public:
    virtual ~ServiceFactory() = default;
    virtual ServicePtr createService(logging::LogPtr logger, const tvm::Ticket& tvmTicket,
        const std::string& requestId) const = 0;
};

using ServiceFactoryPtr = std::shared_ptr<ServiceFactory>;

ServiceFactoryPtr createServiceFactory(mulcagate::SettingsPtr settings,
        mulcagate::http::HttpClientPtr httpClient);

}  // namespace storage
}  // namespace mail_getter
