#ifndef ABSTRACT_STORAGE_STORAGE
#define ABSTRACT_STORAGE_STORAGE

#include <string>

namespace mail_getter {

class AbstractAttachment {
public:
    virtual const std::string& getFilename() const = 0;
    virtual const std::string& getContentType() const = 0;
    virtual const std::string& getBody() const = 0;
    virtual std::size_t getBegin() const = 0;
    virtual std::size_t getEnd() const = 0;

    virtual ~AbstractAttachment() = default;
};

}

#endif
