#pragma once

#include <memory>

#include <mail_getter/MessageAccessDefinitions.h>
#include <mail_getter/optional_yield_context.h>

namespace mail_getter {

struct MessageNotFound : std::runtime_error {
    using std::runtime_error::runtime_error;
};

}

/**
 *  Not to be used from multiple threads, default implementation is not thread-safe
 */
class MessageAccess {
public:
    virtual ~MessageAccess() {}
    virtual MetaPart getHeaderStruct(const std::string &hid) = 0;
    virtual MetaLevel getBodyStruct(const std::string &hid) = 0;
    virtual std::string getHeader(const std::string &hid = rootHid) = 0;
    virtual std::string getBody(const std::string &hid) = 0;
    virtual std::string getWhole() = 0;

    virtual const std::string& getStId() const = 0;

    virtual MetaAttributes getMessageHeaderParsed(const std::string &hid) = 0;
};

using MessageAccessPtr = std::shared_ptr<MessageAccess>;
