#ifndef MESSAGEACCESSDEFINITIONS_H
#define MESSAGEACCESSDEFINITIONS_H

#include <string>
#include <map>
#include <list>

#include <boost/lexical_cast.hpp>
#include <macs/mime_part.h>

extern const std::string wholeMessageHid;
extern const std::string rootHid;

struct asNumCmp
{
    bool operator() (const std::string &s1, const std::string &s2) const
    {
        if(s1==s2)
            return false;
        std::string::size_type b1=0,b2=0;
        while(true) {
            if(b1>=s1.size() || b2>=s2.size())
                return (b1>=s1.size()) && (b2<s2.size());
            std::string::size_type e1,e2;
            e1=s1.find('.',b1);
            e2=s2.find('.',b2);
            std::string p1=s1.substr(b1,e1-b1);
            std::string p2=s2.substr(b2,e2-b2);
            if(p1!=p2) {
                if(p1.empty())
                    return true;
                if(p2.empty())
                    return false;
                return boost::lexical_cast<int>(p1) < boost::lexical_cast<int>(p2);
            }
            if(p1.empty() && p2.empty())
                return false;
            b1=e1;b2=e2;
            if(b1!=std::string::npos) b1++;
            if(b2!=std::string::npos) b2++;
        }
        return false;
    }
};

using MetaAttributes = std::map<std::string, std::string>;
using MetaPart = macs::MimePart;
using MetaParts = std::map<std::string, MetaPart, asNumCmp>;
using MetaLevel = std::list<std::string>;

MetaPart metaAttributesToMetaPart(MetaAttributes ma);
MetaAttributes metaPartToMetaAttributes(const MetaPart& mp);

std::ostream& operator<<(std::ostream& o, const MetaAttributes& attrs);
std::ostream& operator<<(std::ostream& o, const MetaLevel& level);

std::string getStidWithoutPrefix(const std::string& stid);

namespace mail_getter {

MetaAttributes getMessageHeaderParsed(const std::string& hdr);

} // namespace mail_getter

#endif
