#pragma once

#include <mail_getter/AbstractAttachment.h>

namespace mail_getter {

class SimpleAttachment : public AbstractAttachment {
public:
    SimpleAttachment(std::string filename, std::string contentType, std::string body,
        std::size_t begin = 0, std::size_t end = 0);

    const std::string& getFilename() const override;
    const std::string& getContentType() const override;
    const std::string& getBody() const override;

    std::size_t getBegin() const override {
        return begin;
    }

    std::size_t getEnd() const override {
        return end;
    }

    virtual ~SimpleAttachment() = default;
private:
    std::string filename_;
    std::string contentType_;
    std::string body_;
    std::size_t begin;
    std::size_t end;
};

}
