#pragma once

#include <string>
#include <mail_getter/recognizerWrapper.h>
#include <mail_getter/charset_traits.h>
#include <pa/async.h>

class UTFizerException: public std::runtime_error {
public:
    UTFizerException(const std::string& msg)
        : std::runtime_error(msg)
    {}
};

class UTFizer {
public:
    typedef pa::async_profiler Profiler;
    static bool succeeded( int res ) {
        return TextConverter::succeeded(res);
    }
    static bool failed( int res ) {
        return TextConverter::failed(res);
    }

    static int process(const Recognizer::Wrapper& recognizer, const std::string & charset, std::string & text) {
        Profiler profiler;
        return UTFizer(profiler, recognizer).utfize(charset, text);
    }
    static int process(const Recognizer::Wrapper& recognizer, const std::string & charset, std::string & text, Recognizer::LangsEnum & lang) {
        Profiler profiler;
        return UTFizer(profiler, recognizer).utfize(charset, text, lang);
    }
    int utfize(const std::string & charset, std::string & text) const;
    int utfize(const std::string & charset, std::string & text, Recognizer::LangsEnum & lang) const;
    Recognizer::CodesEnum recognizeEncoding(const std::string& text) const;

    UTFizer(const Recognizer::Wrapper& recognizer) : profiler(nullptr), recognizer(&recognizer) {}
    UTFizer(Profiler& profiler, const Recognizer::Wrapper& recognizer) : profiler(&profiler), recognizer(&recognizer) {}
private:
    bool untrustedCharset( const std::string & charset ) const;
    int convert(Recognizer::CodesEnum code, std::string & text) const;
    int convert(const std::string & charset, std::string & text) const;
    int convert(const CharsetTraitsMap::CharsetTraits & traits, std::string & text) const;
    Recognizer::TextTraits recognize(const std::string& text) const;
    Recognizer::TextTraits recognizeWithProfiling(const std::string& text) const;
    Recognizer::CodesEnum recognizeEncodingWithProfiling(const std::string& text) const;
    static const CharsetTraitsMap map;

    Profiler * profiler;
    const Recognizer::Wrapper* recognizer;
};

Recognizer::LangsEnum utfizeStringDetectLang(const Recognizer::Wrapper& recognizer, std::string& content,
                                             const std::string& charset);
void utfizeString(const Recognizer::Wrapper& recognizer, std::string& content, const std::string& charset);
