#pragma once

#include <boost/property_tree/ptree.hpp>
#include <mail_getter/AttachShieldCrypto.h>

namespace mail_getter::attach_sid {

using ptree = boost::property_tree::ptree;

KeyContainer parseKeyContainer(const ptree& tree);
KeyContainer parseKeyContainer(const std::string& aesKeysPath, const std::string& hmacKeysPath);
Keys initKeys(const ptree& tree, const KeyContainer& keyContainer);

} // namespace mail_getter::attach_sid
