#pragma once

#include <mail_getter/AbstractAttachment.h>
#include <mail_getter/optional_yield_context.h>
#include <mail_getter/AttachShieldCrypto.h>

#include <string>
#include <vector>
#include <chrono>

namespace mail_getter {

class AttachmentStorage {
public:
    using VectorOfAttachments = std::vector<std::shared_ptr<AbstractAttachment>>;
    struct MetaInfo {
        std::string previewUrl;
        std::string viewLargeUrl;
        std::string downloadUrl;
        std::string sid;
    };

    virtual int add(const AbstractAttachment& attachment, std::string& id, MetaInfo& metaInformation,
        std::chrono::seconds expireTimeout, std::chrono::seconds shieldTimeout, const attach_sid::Keys& keys,
        OptYieldContext yc = boost::none) = 0;
    virtual int get(const std::vector<std::string>& ids, VectorOfAttachments& result, OptYieldContext yc = boost::none) = 0;

    virtual ~AttachmentStorage() = default;
};

using AttachmentStoragePtr = std::shared_ptr<AttachmentStorage>;

std::string decryptId(const std::string& encryptedId, const attach_sid::KeyContainer& keyContainer);

} // namespace mail_getter
