#pragma once

#include <mail_getter/attachment_storage.h>

namespace mail_getter {
namespace attach_sid {
bool operator==(const attach_sid::Keys &lhs, const attach_sid::Keys &rhs) {
    return lhs.aesKeyId == rhs.aesKeyId
           && static_cast<std::string>(lhs.aesKey) == static_cast<std::string>(rhs.aesKey)
           && lhs.hmacKeyId == rhs.hmacKeyId
           && static_cast<std::string>(lhs.hmacKey) == static_cast<std::string>(rhs.hmacKey);
}
}

class AttachmentStorageMock: public AttachmentStorage {
public:
    MOCK_METHOD(int, add, (const AbstractAttachment&, std::string&, AttachmentStorage::MetaInfo&,
            std::chrono::seconds, std::chrono::seconds, const attach_sid::Keys&, OptYieldContext), (override));
    MOCK_METHOD(int, get, (const std::vector<std::string>&, AttachmentStorage::VectorOfAttachments&, OptYieldContext), (override));
};

} // namespace mail_getter
