#ifndef HTTP_RESPONSE_PARSER_H_2014_09_15
#define HTTP_RESPONSE_PARSER_H_2014_09_15

#include <vector>

#include <mail_getter/mime_type.h>

#include <boost/variant/variant.hpp>
#include <boost/variant/recursive_wrapper.hpp>

namespace mail_getter { namespace http {

typedef std::string PlainData;
struct MultipartData;

class DataPart {
public:
    typedef boost::variant<
                PlainData,
                boost::recursive_wrapper< MultipartData >
        > DataType;
public:
    DataPart();
    DataPart( const std::string& rawPart );
    DataPart( const std::string& data, const std::string& contentType );

    const MimeType& getContentType() const;
    void setContentType(const MimeType& mime);

    const DataType& getData() const;
    void setData( const DataType& data_ );

    const PlainData& getPlainData() const;
    const MultipartData& getMultipartData() const;

    bool isPlain() const;
    bool isMultipart() const {
        return !isPlain();
    }

    void parseContentType( const std::string& rawContentType );
    void parseData( const std::string& rawData );
private:
    MimeType contentType;
    DataType data;
};

bool operator==(const DataPart& lhs, const DataPart& rhs );

struct MultipartData {
    MultipartData( const std::string& rawData, const std::string& boundary );
    typedef std::vector< DataPart > DataParts;
    DataParts parts;
};

bool operator==( const MultipartData& lhs, const MultipartData& rhs );

class IsNotPlainData: public std::runtime_error {
public:
    IsNotPlainData( const std::string& msg )
        : std::runtime_error( msg )
    {}
};

class IsNotMultipartData: public std::runtime_error {
public:
    IsNotMultipartData( const std::string& msg )
        : std::runtime_error( msg )
    {}
};

class InvalidHttpResponse: public std::runtime_error {
public:
	InvalidHttpResponse( const std::string& msg )
        : std::runtime_error( msg )
    {}
};

} // namespace http

http::DataPart parseHttpResponse( const std::string& data, const std::string& contentType = "" );

} // namespace mail_getter

#endif // HTTP_RESPONSE_PARSER_H_2014_09_15
