#ifndef MAIL_GETTER_LOGGING_H
#define MAIL_GETTER_LOGGING_H

#include <memory>
#include <string>

namespace mail_getter {
namespace logging {

using Message = std::string;
using ServiceName = std::string;

class Log {
public:
    virtual ~Log() = default;
    virtual void warning(const ServiceName &, const Message &) = 0;
    virtual void error(const ServiceName &, const Message &) = 0;
    virtual void notice(const ServiceName &, const Message &) = 0;
    virtual void debug(const ServiceName &, const Message &) = 0;
};

using LogPtr = std::shared_ptr<Log>;

} // namespace logging
} // namesopace mail_getter

#endif // MAIL_GETTER_LOGGING_H
