#pragma once

#include <gmock/gmock.h>
#include <mail_getter/MessageAccess.h>

class MessageAccessMock: public MessageAccess {
public:
    MOCK_METHOD(MetaPart, getHeaderStruct, (const std::string&), (override));
    MOCK_METHOD(MetaLevel, getBodyStruct, (const std::string&), (override));
    MOCK_METHOD(std::string, getHeader, (const std::string&), (override));
    MOCK_METHOD(std::string, getBody, (const std::string&), (override));
    MOCK_METHOD(std::string, getWhole, (), (override));

    MOCK_METHOD(const std::string&, getStId, (), (const, override));

    MOCK_METHOD(MetaAttributes, getMessageHeaderParsed, (const std::string&), (override));
};
