#pragma once

#include <mail_getter/MessageAccessDefinitions.h>
#include <mail_getter/MessageAccess.h>
#include <mail_getter/types.h>

namespace mail_getter {

class MetaPartsConverter {
public:
    virtual ~MetaPartsConverter() = default;
    virtual MetaParts getMetaPartsFromXml(const Stid& stid, OptYieldContext yc = boost::none) const = 0;
    virtual MetaParts extractMetaPartsFromInline(MessageAccessPtr messageAccess,
        const MetaPart& inlineMessagePart, OptYieldContext yc = boost::none) const = 0;
};

using MetaPartsConverterPtr = std::shared_ptr<MetaPartsConverter>;

}
