#pragma once

#include <mail_getter/hooks.h>

namespace mail_getter {
namespace mulcagate {

enum class Errors {
    httpCode = 1,
    exception,
    dataNotFound,
    badRange,
    internal,
};

class Category : public error_category {
public:
    const char* name() const noexcept {
        return "mulcagate";
    }

    std::string message(int error) const {
        switch(Errors(error)) {
            case Errors::httpCode: return "bad http code";
            case Errors::exception: return "exception was caught";
            case Errors::dataNotFound: return "data not found";
            case Errors::badRange: return "bad bytes range";
            case Errors::internal: return "mulcagate internal error";
        }

        return "unknown error";
    }
};

inline const error_category& getCategory() {
    static Category instance;
    return instance;
}

inline error_code::base_type make_error_code(Errors e) {
    return error_code::base_type(static_cast<int>(e), getCategory());
}

} // namespace mulcagate
} // namespace mail_getter

namespace boost {
namespace system {

template <>
struct is_error_code_enum<mail_getter::mulcagate::Errors> : std::true_type {};

} // namespace system
} // namespace boost
