#ifndef MAIL_GETTER_MULCAGATE_HTTP_H
#define MAIL_GETTER_MULCAGATE_HTTP_H

#include <memory>
#include <functional>
#include <chrono>

#include <butil/http/arguments.h>
#include <butil/http/headers.h>
#include <butil/http/url.h>
#include <butil/tvm_ticket.h>

#include <mail_getter/mulcagate/errors.h>

namespace mail_getter {
namespace mulcagate {
namespace http {

using Timeout = std::chrono::milliseconds;
using Headers = ::http::headers;

struct BaseParams {
    std::string host;
    unsigned port = 0;
    std::string path;
    Timeout connectTimeout{1000};
    Timeout timeout{1000};
    bool keepAlive = false;
    Headers headers;
    HttpArguments args;
    tvm::Ticket tvmTicket;
    std::string requestId;

    BaseParams(const std::string& host, unsigned port, const std::string& path,
            const Timeout& connectTimeout, const Timeout& timeout, bool keepAlive, const Headers& headers,
            const HttpArguments& args, const tvm::Ticket& tvmTicket, const std::string& requestId)
            : host(host), port(port), path(path), connectTimeout(connectTimeout), timeout(timeout),
              keepAlive(keepAlive), headers(headers), args(args), tvmTicket(tvmTicket), requestId(requestId) {
    }
};

struct Response {
    unsigned code = 0;
    std::string body;

    Response() = default;
    Response(unsigned code, const std::string& body) : code(code), body(body) {}
};

using ResponseHandler = Hook<Response>;

class HttpClient {
public:
    virtual ~HttpClient() = default;

    virtual void aget(const BaseParams& params, ResponseHandler handler) const = 0;

    virtual void apost(const BaseParams& params, const std::string& data, ResponseHandler handler) const = 0;
};

typedef std::shared_ptr<const HttpClient> HttpClientPtr;

} // namespace http
} // namespace mulcagate
} // namespace mail_getter

#endif // MAIL_GETTER_MULCAGATE_HTTP_H
