#pragma once

#include <mail_getter/hooks.h>

#include <boost/asio/spawn.hpp>
#include <boost/optional.hpp>

using OptYieldContext = boost::optional<boost::asio::yield_context>;

template <class Handler>
decltype(auto) applyOptYieldContext(OptYieldContext yc, mail_getter::error_code& ec, Handler&& handler) {
    if (yc) {
        return handler(mail_getter::io::make_yield_context(yc.get())[ec]);
    } else {
        return handler(mail_getter::io::use_sync[ec]);
    }
}
