#pragma once

#include <mail_getter/types.h>
#include <boost/variant.hpp>
#include <string>
#include <vector>

namespace mail_getter {
namespace part_id {

struct Old {
    Stid stid;
    Hid hid;
};

struct Temporary {
    Stid stid;
    Hid hid;
};

struct SingleMessagePart {
    Uid uid;
    Mid mid;
    Hid hid;
};

struct MultipleMessagePart {
    Uid uid;
    Mid mid;
    std::vector<Hid> hids;
};

using Variant = boost::variant<
    Old,
    Temporary,
    SingleMessagePart,
    MultipleMessagePart
>;

} // namespace part_id
} // namespace mail_getter
