#pragma once

#include <string>
#include <vector>
#include <boost/optional.hpp>

namespace mail_getter {

enum SanitizerMarkupType {
      SanitizerMarkupType_Start = 1,

      SanitizerMarkupType_Image = 1,
      SanitizerMarkupType_Cid = 2,
      SanitizerMarkupType_Link = 3,
      SanitizerMarkupType_Class = 4,
      SanitizerMarkupType_UnsafeLink = 5,

      SanitizerMarkupType_End
};

struct MarkupPosition {
    std::size_t attributeStart;
    std::size_t attributeLength;
    std::size_t dataStart;
    std::size_t dataLength;
};

struct SanitizerMarkupEntry {
    SanitizerMarkupType type;
    boost::optional<std::string> classValue;
    MarkupPosition position;
};
typedef std::vector<SanitizerMarkupEntry> SanitizerMarkup;

SanitizerMarkup parseSanitizerMarkup(const std::string& json);

} // namespace mail_getter
