#ifndef SANITIZER_RESPONSE_PROCESSOR_H_2014_09_15
#define SANITIZER_RESPONSE_PROCESSOR_H_2014_09_15

#include <stdexcept>
#include <string>

#include <mail_getter/mime_type.h>
#include <mail_getter/sanitizer/sanitizer_markup.h>

namespace mail_getter {

namespace http {
class DataPart;
}

class SanitizerParseException: public std::runtime_error {
public:
    SanitizerParseException(const std::string& msg)
        : std::runtime_error(msg) {
    }
};

struct SanitizerParsedResponse {
    std::string html;
    SanitizerMarkup markup;
};

class SanitizerResponseProcessor {
public:
    SanitizerParsedResponse operator() (const std::string& data, const std::string& contentType) const;
private:
    const std::string& getHtmlPart(const http::DataPart& parsedData) const;
    SanitizerMarkup getSanitizerMarkup(const http::DataPart& parsedData) const;
};

static const SanitizerResponseProcessor processSanitizerResponse = SanitizerResponseProcessor();

} // namespace mail_getter

#endif // SANITIZER_RESPONSE_PROCESSOR_H_2014_09_15
