#pragma once

#include <mail_getter/MessageAccess.h>
#include <mail_getter/MessageAccessParams.h>
#include <mail_getter/attachment_storage.h>
#include <mail_getter/meta_parts_converter.h>
#include <mail_getter/recognizerWrapper.h>

namespace mail_getter {

class Service {
public:
    virtual ~Service() = default;

    virtual MessageAccessPtr createMessageAccess(MessageAccessParams params,
            const Recognizer::Wrapper& recognizer, OptYieldContext yc = boost::none) const = 0;
    virtual MessageAccessPtr createMessageAccess(MessageAccessWithWindatParams params,
            const Recognizer::Wrapper& recognizer, OptYieldContext yc = boost::none) const = 0;
    virtual AttachmentStoragePtr createAttachmentStorage(const std::string& webAttachHost) const = 0;
    virtual MetaPartsConverterPtr createMetaPartsConverter(const Recognizer::Wrapper& recognizer) const = 0;
};

using ServicePtr = std::shared_ptr<Service>;

}  // namespace mail_getter
