#pragma once

#include <memory>
#include <mail_getter/service.h>

namespace mail_getter {

class ServiceMock: public Service {
public:
    MOCK_METHOD(MessageAccessPtr, createMessageAccess, (MessageAccessParams, const Recognizer::Wrapper&, OptYieldContext), (const, override));
    MOCK_METHOD(MessageAccessPtr, createMessageAccess, (MessageAccessWithWindatParams, const Recognizer::Wrapper&, OptYieldContext), (const, override));
    MOCK_METHOD(AttachmentStoragePtr, createAttachmentStorage, (const std::string&), (const, override));
    MOCK_METHOD(MetaPartsConverterPtr, createMetaPartsConverter, (const Recognizer::Wrapper&), (const, override));
};

} // namespace mail_getter
