#pragma once

#include <butil/crypt.h>
#include <yamail/data/deserialization/json_reader.h>
#include <yamail/data/serialization/json_writer.h>
#include <macs/types.h>
#include <mail_getter/base64_url.h>

BOOST_FUSION_DEFINE_STRUCT((mail_getter)(sms), TimedUidMid,
    (std::string, uid)
    (std::string, mid)
    (time_t, ts)
)

namespace mail_getter {
namespace sms {

class Parser {
public:
    virtual ~Parser() {}
    virtual TimedUidMid parse(const std::string& sid) const = 0;
    virtual std::string serialize(const TimedUidMid& timedUidMid) const = 0;
};

using ParserPtr = std::unique_ptr<Parser>;
ParserPtr getParser(std::chrono::seconds timeToLive);

} // namespace sms
} // namespace mail_getter
