#ifndef MAIL_GETTER_TYPES_H_
#define MAIL_GETTER_TYPES_H_

#include <functional>
#include <mail_errors/error_code.h>

namespace mail_getter {

using Stid = std::string;
using Hid = std::string;
using Uid = std::string;
using Mid = std::string;

struct Range {
    std::size_t first = 0;
    std::size_t last = 0;

    Range(std::size_t first, std::size_t last) : first(first), last(last) {}
};

inline std::string toString(const Range& range) {
    return std::to_string(range.first) + "-" + std::to_string(range.last);
}

}

#endif // MAIL_GETTER_TYPES_H_
