#ifndef SECURE_VDIRECT_H_173425032012
#define SECURE_VDIRECT_H_173425032012

#include <string>
#include <butil/http/url.h>
#include <mail_getter/vdirect/interface.h>
#include <mail_getter/vdirect/keys_storage.h>
#include <mail_getter/vdirect/hash_provider.h>

class SecureVdirect : public Vdirect {
public:
    struct Params {
        bool https;
        std::string domain;
        std::string scriptName;

        Params( bool https,
                const std::string & domain,
                const std::string & scriptName)
        : https(https), domain(domain), scriptName(scriptName) {}
    };

    SecureVdirect(const Params & params, vdirect::HashProviderPtr hashProvider_)
    : params_(params), unwrapPattern(makeUnwrapPattern()),
      hashProvider(std::move(hashProvider_)) {
    }
    virtual std::string processA(const std::string& str_) const;
    virtual void unwrap(std::string& str) const;
    virtual std::string process(const std::string& stuff_) const;
    virtual std::string getUnwrapPattern() const;
    virtual std::string unwrapUrl(const std::string & urlPart) const;
private:
    static std::string encode(const http::url & url);
    std::string hash(const std::string & url) const;
    std::string makeUnwrapPattern() const;

    bool https() const {
        return params_.https;
    }
    const std::string & domain() const {
        return params_.domain;
    }
    const std::string & scriptName() const {
        return params_.scriptName;
    }

    Params params_;
    std::string unwrapPattern;
    vdirect::HashProviderPtr hashProvider;

    static const std::string linkParamPrefix;
};

#endif /* SECURE_VDIRECT_H_173425032012 */
