'use strict';

module.exports = {
    root: true,

    env: {
        es6: true,
        node: true
    },

    plugins: [
        'node',
        'security'
    ],

    extends: [
        'eslint:recommended',
        'yandex-personal/es6',
        'plugin:node/recommended'
    ],

    rules: {
        'keyword-spacing': [ 'error', { before: true, after: true } ],

        // plugins
        'node/exports-style': [ 'error', 'module.exports' ],
        'security/detect-buffer-noassert': [ 'error' ],
        'security/detect-pseudoRandomBytes': [ 'error' ],

        // warnings
        'no-warning-comments': [ 'warn', { location: 'anywhere' } ],

        // off
        'node/shebang': 'off',
        'node/no-unpublished-require': 'off',
        'node/no-extraneous-require': 'off',
        'prefer-arrow-callback': 'off',
        'padded-blocks': 'off',
        'prefer-spread': 'off',
        'prefer-rest-params': 'off',
        'no-eq-null': 'off',
        'object-shorthand': 'off'
    }
};

const jestConfig = {
    files: [
        '__tests__/**/*.js'
    ],

    env: {
        jest: true
    },

    plugins: [ 'jest' ],

    rules: {
        'jest/consistent-test-it': 'error',
        'jest/expect-expect': 'error',
        'jest/lowercase-name': 'error',
        'jest/no-disabled-tests': 'error',
        'jest/no-focused-tests': 'error',
        'jest/no-identical-title': 'error',
        'jest/prefer-to-be-null': 'error',
        'jest/prefer-to-be-undefined': 'error',
        'jest/prefer-to-contain': 'error',
        'jest/prefer-to-have-length': 'error',
        'jest/valid-describe': 'error',
        'jest/valid-expect': 'error',
        'jest/valid-expect-in-promise': 'error'
    }
};

module.exports.overrides = [ jestConfig ];
