'use strict';

const { readFileSync } = require('fs');
const { createHash, createDecipheriv } = require('crypto');

const base64safe = (buffer) => buffer.toString('base64')
    .replace(/\+/g, '-')
    .replace(/\//g, '_')
    .replace(/={1,3}$/, '');

const md5 = (string) => base64safe(createHash('md5').update(string).digest());

const calculateHash = (secret, uid, link) => md5(link + uid + secret);

const getPair = (string, delimiter) => {
    const pos = string.indexOf(delimiter);
    if (pos < 0) {
        return [ null, null ];
    }
    return [
        string.slice(0, pos),
        string.slice(pos + 1)
    ];
};

const getKeys = (path) => readFileSync(path, 'ascii')
    .split('\n')
    .reduce((keys, string, idx, array) => {
        if (string === '' && idx === array.length - 1) {
            return keys;
        }
        const [ key, secret ] = getPair(string, ':');
        if (key === null) {
            throw new Error('Cannot find delimiter');
        }
        keys.set(key, secret);
        return keys;
    }, new Map());

const getDecrypt = (smsSecretsPath) => {
    const secrets = JSON.parse(readFileSync(smsSecretsPath, 'utf8'));
    const ALG = secrets[0].alg;
    const KEY = Buffer.from(secrets[0].key);
    const IV = Buffer.from(secrets[0].iv);

    return (string) => {
        const d = createDecipheriv(ALG, KEY, IV);
        try {
            return d.update(string, 'base64', 'utf8') + d.final('utf8');
        } catch (e) {
            return null;
        }
    };
};

module.exports = {
    calculateHash,
    getKeys,
    getPair,
    getDecrypt
};
