'use strict';

const { calculateHash, getDecrypt, getPair, getKeys } = require('./utils.js');

function vdirect(keysPath, smsSecretsPath) {
    const keys = getKeys(keysPath);
    // first key is default
    const key = keys.keys().next().value;
    const secret = keys.get(key);

    const createHashForUidLink = (uid, link) => `${key},${calculateHash(secret, uid, link)}`;

    const validateHashForUidLink = (uid, link, keyHash) => {
        const [ key, hash ] = getPair(keyHash, ',');
        if (key === null || !keys.has(key)) {
            return false;
        }
        return hash === calculateHash(keys.get(key), uid, link);
    };

    if (smsSecretsPath !== undefined) {
        const decrypt = getDecrypt(smsSecretsPath);

        const validateHashForSmsLink = (link, keyHash, ttl) => {
            const [ key, tmp ] = getPair(keyHash, ',');
            if (key === null || !keys.has(key)) {
                return false;
            }

            const [ smsSid, hash ] = getPair(tmp, ',');
            if (smsSid === null || hash !== calculateHash(keys.get(key), smsSid, link)) {
                return false;
            }

            const [ version, json ] = getPair(decrypt(smsSid) || '', ',');
            if (version !== 'v2') {
                return false;
            }

            const { ts } = JSON.parse(json);
            if (Date.now() > (ts + ttl) * 1000) {
                return false;
            }

            return true;
        };

        return {
            createHashForUidLink,
            validateHashForUidLink,
            validateHashForSmsLink
        };
    }

    return {
        createHashForUidLink,
        validateHashForUidLink
    };
}

module.exports = vdirect;
