#include <internal/HeaderParser.h>
#include <algorithm>
#include <butil/StrUtils/ToLower.h>

HeaderParser::HeaderParser(MetaAttributes &_ma, const std::string &buf)
        : mulca_mime::header(buf), ma(_ma) {
}

bool HeaderParser::handle_field(const std::string &name, const std::string::size_type beg,
        const std::string::size_type end) {
    std::string lcname(name.size(),' ');
    ToLower lowercase;
    std::transform(name.begin(),name.end(),lcname.begin(),lowercase);
    if ( (lcname == "cc" || lcname == "to" || lcname == "bcc") && !ma[lcname].empty() ) {
        ma[lcname].append(",");
    }
    if ( (lcname == "authentication-results" ) && !ma[lcname].empty() ) {
        ma[lcname].append(";");
    }
    ma[lcname].append(buffer.substr(beg,end-beg));
    return true;
}
