#include <mail_getter/MessageAccessParams.h>
#include <macs/envelopes_repository.h>

namespace mail_getter {

MessageAccessParams getMessageAccessParams(macs::Stid stid) {
    if (stid.empty()) {
        throw std::invalid_argument("getMessageAccessParams error: empty stid");
    }

    return { std::move(stid), MetaParts() };
}

MessageAccessParams getMessageAccessParams(macs::Stid stid, macs::MimeParts mimeParts) {
    MetaParts metaParts;
    boost::transform(mimeParts, std::inserter(metaParts, metaParts.end()), [] (auto& mp) {
        auto hid = mp.hid();
        return std::make_pair(std::move(hid), std::move(mp));
    });

    return { std::move(stid), std::move(metaParts) };
}

MessageAccessParams getMessageAccessParams(MidStidMime data) {
    macs::Stid stid;
    macs::MimeParts mimeParts;
    std::tie(std::ignore, stid, mimeParts) = std::move(data);

    return getMessageAccessParams(std::move(stid), std::move(mimeParts));
}

} // namespace mail_getter
