#include <mail_getter/SimpleAttachment.h>

namespace mail_getter {

SimpleAttachment::SimpleAttachment(std::string filename, std::string contentType, std::string body,
        std::size_t begin, std::size_t end)
        : filename_(std::move(filename)), contentType_(std::move(contentType)), body_(std::move(body)),
          begin(begin), end(end) {
}

const std::string& SimpleAttachment::getFilename() const {
    return filename_;
}

const std::string& SimpleAttachment::getBody() const {
    return body_;
}

const std::string& SimpleAttachment::getContentType() const {
    return contentType_;
}

}
