#include <vector>
#include <butil/butil.h>
#include <butil/StrUtils/strtr.h>
#include <mail_getter/base64_url.h>

typedef std::vector<std::pair<char, char> > ReplaceMap;

namespace {
ReplaceMap makeEncodeBase64urlMap(bool noEqualsSign) {
    ReplaceMap map;
    map.push_back(std::make_pair('+', '-'));
    map.push_back(std::make_pair('/', '_'));
    if (noEqualsSign) {
        map.push_back(std::make_pair('=', 0));
    } else {
        map.push_back(std::make_pair('=', ','));
    }
    return map;
}

static const ReplaceMap encodeBase64urlMapNoEq(makeEncodeBase64urlMap(true));

static const ReplaceMap encodeBase64urlMap(makeEncodeBase64urlMap(false));
}

void encode_base64url(std::string& str, bool noEqualsSign) {
    str = encode_base64( str );
    strtr(str, (noEqualsSign ? encodeBase64urlMapNoEq : encodeBase64urlMap) );
}
namespace {
ReplaceMap makeDecodeBase64urlMap() {
    ReplaceMap map;
    map.push_back(std::make_pair('-', '+'));
    map.push_back(std::make_pair('_', '/'));
    map.push_back(std::make_pair('*', '='));
    map.push_back(std::make_pair(',', '='));
    return map;
}

static const ReplaceMap decodeBase64urlMap(makeDecodeBase64urlMap());
}
std::string decode_base64url(const std::string& str_) {
    std::string str = str_;
    strtr(str, decodeBase64urlMap);
    str = decode_base64(str);
    return str;
}
