#include <internal/message_access_impl.h>

namespace mail_getter {

MessageAccessImpl::MessageAccessImpl(const std::string &stId, MessageStoragePtr storage,
        OptYieldContext yc)
        : stid(stId), storage_(std::move(storage)), yc_(yc) {
    if (!storage_) {
        throw std::invalid_argument(std::string(__PRETTY_FUNCTION__) + ": need storage");
    }
}

MetaPart MessageAccessImpl::getHeaderStruct(const std::string &hid) {
    auto res = storage()->getHeaderStruct(hid, yc_);
    if (!res) {
        std::ostringstream s;
        s << "Can't get message header struct, stid=" << getStId() << ", hid=" << hid
                << ": unknown hid";
        throw MessageNotFound(s.str());
    }
    return std::move(*res);
}

MetaLevel MessageAccessImpl::getBodyStruct(const std::string &hid) {
    return storage()->getBodyStruct(hid, yc_);
}

std::string MessageAccessImpl::getHeader(const std::string &hid) {
    auto res = storage()->getHeader(hid, yc_);
    if (!res) {
        std::ostringstream s;
        s << "Can't get message header, stid=" << getStId() << ", hid=" << hid
                << ": unknown hid";
        throw MessageNotFound(s.str());
    }
    return std::move(*res);
}

std::string MessageAccessImpl::getBody(const std::string &hid) {
    auto res = storage()->getBody(hid, yc_);
    if (!res) {
        std::ostringstream s;
        s << "Can't get message body, stid=" << getStId() << ", hid=" << hid
                << ": unknown hid";
        throw MessageNotFound(s.str());
    }
    return std::move(*res);
}

std::string MessageAccessImpl::getWhole() {
    return storage()->getWhole(yc_);
}

const std::string& MessageAccessImpl::getStId() const {
    return stid;
}

MetaAttributes MessageAccessImpl::getMessageHeaderParsed(const std::string &hid) {
    auto hdr = getHeader(hid);
    return mail_getter::getMessageHeaderParsed(hdr);
}

} // namespace mail_getter
