#include <yamail/data/deserialization/ptree_reader.h>
#include <mail_getter/mulcagate/integration.h>

#define CHANGE_NAME(TYPE, CONF_NAME, NAME)      (CONF_NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)
#define AS_IS(TYPE, NAME)                       (NAME, TYPE, TYPE, obj.NAME, obj.NAME = val)

YREFLECTION_ADAPT_ADT(mail_getter::mulcagate::Settings,
    CHANGE_NAME(std::string, storage_name_space, storageNameSpace)
    AS_IS(std::string, service)
    AS_IS(std::string, host)
    AS_IS(unsigned, port)
    CHANGE_NAME(unsigned, connect_timeout_ms, connectTimeoutMs)
    CHANGE_NAME(unsigned, get_timeout_ms, getTimeoutMs)
    CHANGE_NAME(unsigned, put_timeout_ms, putTimeoutMs)
    AS_IS(unsigned, retries)
    CHANGE_NAME(bool, keep_alive, keepAlive)
)

#undef CHANGE_NAME
#undef AS_IS

namespace mail_getter {
namespace mulcagate {

SettingsPtr parseMulcagateSettings(const ptree& mulcagateTree) {
    try {
        return yamail::data::deserialization::fromPtree<SettingsPtr>(mulcagateTree);
    } catch (const std::exception& e) {
        throw std::runtime_error("failed to init mulcagate settings: " + std::string(e.what()));
    }
}

} // namespace mulcagate
} // namespace mail_getter
