#include <mail_getter/sanitizer/sanitizer_markup.h>

#include <boost/bind.hpp>
#include <yamail/data/reflection/reflection.h>
#include <yamail/data/deserialization/json_reader.h>

namespace mail_getter {
namespace reflection {

struct SanitizerMarkupEntry {
    int type;
    boost::optional<std::string> classValue;
    std::vector<std::size_t> position;
};
typedef std::vector<SanitizerMarkupEntry>  SanitizerMarkup;

}
}
BOOST_FUSION_ADAPT_STRUCT(mail_getter::reflection::SanitizerMarkupEntry,
    (int, type)
    (boost::optional<std::string>, classValue)
    (std::vector<std::size_t>, position)
)

namespace mail_getter {

SanitizerMarkupType convertToSanitizerMarkupType(int type) {
    if (type < SanitizerMarkupType_Start || type >= SanitizerMarkupType_End) {
        throw std::runtime_error("bad Markup Type");
    }
    return SanitizerMarkupType(type);
}

SanitizerMarkupEntry convertMarkupEntry(const reflection::SanitizerMarkupEntry &entry) {
    if (entry.position.size() != 4) {
        throw std::runtime_error("position - incorrect count of items");
    }
    SanitizerMarkupEntry markupEntry;
    markupEntry.type = convertToSanitizerMarkupType(entry.type);
    markupEntry.classValue = entry.classValue;
    markupEntry.position.attributeStart = entry.position[0];
    markupEntry.position.attributeLength = entry.position[1];
    markupEntry.position.dataStart = entry.position[2];
    markupEntry.position.dataLength = entry.position[3];
    return markupEntry;
}

SanitizerMarkup parseSanitizerMarkup(const std::string& json) {
    using namespace yamail::data::deserialization;
    SanitizerMarkup markup;

    if (!json.compare(0, 4, "null")) {
        return markup;
    }

    auto innerMarkup = fromJson<reflection::SanitizerMarkup>(json);

    std::transform(innerMarkup.begin(), innerMarkup.end(),
            std::back_inserter(markup),
            boost::bind(convertMarkupEntry, _1) );
    return markup;
}

}
