#include <internal/storage/service_factory.h>

#include <mail_getter/service_factory.h>
#include <internal/service.h>

namespace mail_getter {

class ServiceFactoryImpl : public ServiceFactory {
public:
    ServiceFactoryImpl(mulcagate::SettingsPtr settings, mulcagate::http::HttpClientPtr httpClient)
            : settings_(std::move(settings)),
              storageServiceFactory_(storage::createServiceFactory(settings_, httpClient)) {
    }

    ServicePtr createService(logging::LogPtr logger, const tvm::Ticket& tvmTicket,
            const std::string& requestId) const override {
        return std::make_shared<ServiceImpl>(settings_, logger,
                storageServiceFactory_->createService(logger, tvmTicket, requestId));
    }

private:
    mulcagate::SettingsPtr settings_;
    storage::ServiceFactoryPtr storageServiceFactory_;
};

ServiceFactoryPtr createServiceFactory(mulcagate::SettingsPtr settings,
        mulcagate::http::HttpClientPtr httpClient) {
    return std::make_shared<ServiceFactoryImpl>(std::move(settings), std::move(httpClient));
}

}  // namespace mail_getter
