#include <future>
#include <internal/storage/mulcagate_service.h>

namespace mail_getter {
namespace storage {

void MulcagateService::asyncGetBlob(const Stid& stid, OnGetBlob handler) const {
    mulcagateClient->getWhole(stid, handler);
}

void MulcagateService::asyncPutBlob(const std::string& baseId, const std::string& data, std::chrono::seconds ttl,
        OnPutBlob handler) const {
    mulcagateClient->putData(baseId, data, ttl, handler);
}

void MulcagateService::asyncGetXml(const Stid& stid, OnGetXml handler) const {
    mulcagateClient->getXml(stid, handler);
}

void MulcagateService::asyncGetByRange(const Stid& stid, const Range& range, OnGetBlob handler) const {
    mulcagateClient->getByRange(stid, range, handler);
}

}  // namespace storage
}  // namespace mail_getter
