#include <internal/storage/service_factory.h>

#include <internal/storage/mulcagate_service.h>

namespace mail_getter {
namespace storage {

class ServiceFactoryImpl : public ServiceFactory {
public:
    ServiceFactoryImpl(mulcagate::SettingsPtr settings, mulcagate::http::HttpClientPtr httpClient)
        : settings(std::move(settings)), httpClient(std::move(httpClient))
    {}

    ServicePtr createService(logging::LogPtr logger, const tvm::Ticket& tvmTicket,
            const std::string& requestId) const override {
        auto mulcagateClient = std::make_shared<mulcagate::MulcagateClient>(
                settings, httpClient, logger, tvmTicket, requestId);
        return std::make_shared<MulcagateService>(mulcagateClient);
    }

private:
    mulcagate::SettingsPtr settings;
    mulcagate::http::HttpClientPtr httpClient;
    logging::LogPtr logger;
};

ServiceFactoryPtr createServiceFactory(mulcagate::SettingsPtr settings,
        mulcagate::http::HttpClientPtr httpClient) {
    return std::make_shared<ServiceFactoryImpl>(std::move(settings), std::move(httpClient));
}


}  // namespace storage
}  // namespace mail_getter
