
from django.core.management import call_command, setup_environ
import os, sys

app_path = os.path.join(os.path.abspath(os.path.dirname(__file__)), '..', '..', 'src', 'maillists')
sys.path = [app_path] + sys.path

import settings

to_delete = [
    "support_afisha", "support_relanium", "support_weather", "support_adresa", "support_balance", "support_blogs",
    "support_cards", "support_catalog", "support_desktop", "support_direct", "support_firefox", "support_fotki",
    "support_games", "noreplay_news", "support_kubok", "support_lenta", "support_lingvo", "support_mail",
    "support_maps", "support_market", "support_money", "support_narod", "support_news", "support_partner",
    "support_partners", "support_play", "support_slovari", "support_sphere", "support_online", "support_terms",
    "support_toolbar", "support_tv", "support_validator", "support_webmail", "support_wi-fi", "support_xml",
    "support_zakladki", "info_kubok", "info_narod", "info_news", "info_wi-fi", "manager_narod",
    "manager_support", "admin_narod", "alerts_market", "billing_sphere", "model_market", "nobody_narod",
    "partner_money", "pobediteli_support", "account_direct", "traffic_support", "notifications_partner",
    "dev-team_moikrug", "marketing_moikrug", "support-team_moikrug", "s_zhilin_moikrug", "docs_partner",
    "support_friends", "support_moikrug", "yp_support_adresa", "support_next", "otmena-banks_money",
    "support_images", "support_m", "support_mobile", "support_nahodki", "support_calendar", "next_mail",
    "support_school", "support_captcha", "support_wmconsole", "support_notifier", "support_punto", "support_nano",
    "support_mobfotki", "support_kuda", "support_local", "support_direct_ua", "quality_market",
    "badquality_market", "support_disk", "support_transport", "support_auto", "info_auto", "beta_maps",
    "support_time", "xml-import_images", "next_mobile", "info_maps", "manufacturer_auto", "partner_market",
]

setup_environ(settings)

deleted = 0
need_reindex = 0
for list in to_delete:
    try:
        messages_count = call_command("deletelist", list)
        if messages_count:
            need_reindex += messages_count
        deleted += 1
    except Exception, e:
        print "Successfully deleted " + str(deleted) + " maillists"
        print "Failed at maillist: " + list
        raise e

print "Deleted all maillists (" + str(deleted) + ")"
if need_reindex:
    print "Reindex needed! (deleted " + str(need_reindex) + " messages)"