#!/bin/bash

VERBOSE=0
NEED_BACKUP=0

DB_USERNAME=wakka
DB_PASSWORD=wackowiki
UPGRADE_DB_NAME=maillists

# Do not change anything below this line, if you are not sure what you are doing
# ------------------------------------------------------------------------------

LAUNCH_DIR=$(dirname $0)
if test $(which realpath)
then
    LAUNCH_DIR=$(realpath $LAUNCH_DIR)
fi
BACKUP_DB_FILE=$LAUNCH_DIR/$UPGRADE_DB_NAME-backup.sql
DATA_DB_FILE=$LAUNCH_DIR/$UPGRADE_DB_NAME-data.sql
UPGRADE_DB_SQL=$LAUNCH_DIR/upgrade-db.sql

ROOT_DIR=$LAUNCH_DIR/../..
if test $(which realpath)
then
    ROOT_DIR=$(realpath $ROOT_DIR)
fi
MANAGE=$ROOT_DIR/src/maillists/manage.py

if test $VERBOSE -gt 0
then
    echo Configured values:
    echo  - ROOT_DIR=$ROOT_DIR
    echo  - LAUNCH_DIR=$LAUNCH_DIR
    echo  - MANAGE=$MANAGE
    echo  - BACKUP_DB_FILE=$BACKUP_DB_FILE
    echo  - DATA_DB_FILE=$DATA_DB_FILE
    echo  - UPGRADE_DB_SQL=$UPGRADE_DB_SQL
fi

if test $NEED_BACKUP -gt 0
then
    # create db backup
    echo -n Creating backup of database $UPGRADE_DB_NAME to file $BACKUP_DB_FILE ...
    mysqldump --complete-insert --order-by-primary --quote-names -u$DB_USERNAME $UPGRADE_DB_NAME -p$DB_PASSWORD > $BACKUP_DB_FILE
    if test $? -gt 0
    then
        echo Error
        exit $?
    fi
    echo Done
fi

# upgrade db with sql script
echo -n Upgrading database $UPGRADE_DB_NAME from script $UPGRADE_DB_SQL ...
mysql -u$DB_USERNAME $UPGRADE_DB_NAME -p$DB_PASSWORD < $UPGRADE_DB_SQL
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

# make data snapshot
echo -n Making data only snapshot of database $UPGRADE_DB_NAME ...
mysqldump --complete-insert --order-by-primary --quote-names --no-create-info -u$DB_USERNAME $UPGRADE_DB_NAME -p$DB_PASSWORD > $DATA_DB_FILE
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

# recreate db
echo -n Dropping database $UPGRADE_DB_NAME ...
mysql --execute="DROP DATABASE $UPGRADE_DB_NAME;" -u$DB_USERNAME -p$DB_PASSWORD
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

echo -n Create database $UPGRADE_DB_NAME ...
mysql --execute="CREATE DATABASE $UPGRADE_DB_NAME DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;" -u$DB_USERNAME -p$DB_PASSWORD
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

# create new db structure
echo Creating new database structure
$MANAGE syncdb
$MANAGE migrate
echo Done creating new database structure

# apply data snapshot
echo -n Applying data snapshot to database $UPGRADE_DB_NAME ...
mysql --database=$UPGRADE_DB_NAME -u$DB_USERNAME -p$DB_PASSWORD < $DATA_DB_FILE
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

# rm data snapshot
echo -b Removing data snapshot file $DATA_DB_FILE ...
rm $DATA_DB_FILE
if test $? -gt 0
then
    echo Error
    exit $?
fi
echo Done

echo All done
