#!/usr/bin/python
# encoding: utf-8

import sys
import os

# --- /usr/lib/yandex/tools-maillists/src/maillists/manage.py

# sys.path = ['/home/fantasy/ml',
#             '/home/fantasy/ml/src',
#             '/home/fantasy/ml/src/maillists',
#             '/etc/yandex/tools-maillists/celery/',
#             ] + sys.path
sys.path = ['/etc/yandex/tools-maillists',
            '/usr/lib/yandex/tools-maillists/src',
            '/usr/lib/yandex/tools-maillists/src/maillists',
            '/etc/yandex/tools-maillists/celery/',
            ] + sys.path


os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

import logging
from mlcore.utils.getters import get_list, get_user
from mlcore.tasks.base import create_maillist, subscribe_inbox
import time
from mlcore.subscribe.backends.yandex_team.models import YandexTeamBackendContext

log = logging.getLogger(__name__)



if __name__ == "__main__":
    f = open("autoru_maillist_inbox.txt", "r")
    exists_count = 0
    create_count = 0
    inbox_logins = {}
    for line in f:
        name_maillist, subscribers = line.split()
        inbox_logins[name_maillist] = subscribers.split(',')
        email_to_list = name_maillist if '@' in name_maillist else name_maillist+'@auto.ru'
        try:
            # Если есть такая рассылка, то ничего не делаем, иначе - создаем
            get_list(email_to_list)
            exists_count += 1
        except YandexTeamBackendContext.DoesNotExist:
            # создание рассылок c ответсвенными owners = []
            context = {
                'initiator': 'bonifaci',
                'comment': u'ML-1343: Рассылки для auto.ru',
            }
            data = {
                'name': email_to_list,
                'responsible': set([u'miroku@yandex-team.ru', u'mlysov@yandex-team.ru']),
                'info': 'Auto.ru',
                'info_en': 'Auto.ru',
                'is_open': True,
                'is_internal': True,
                'archive': False,
                'before_clean': 0,
            }
            r = create_maillist(context, data, 'miroku').delay()
            print r,
            time.sleep(2)
            print r.status, r.task_name, r.result, r.traceback
            create_count += 1
    print create_count, exists_count

    auto_to_yt = {}
    if exists_count > 0:
        for name_ml in inbox_logins:
            for yt_subscriber in inbox_logins[name_ml]:
                context = {
                    'initiator': 'bonifaci',
                    'comment': u'ML-1343: Auto.ru, подписка %s на %s)' % (yt_subscriber, name_ml),
                }
                try:
                    auto_user = get_user(yt_subscriber)
                    auto_maillist = get_list(name_ml)
                    s = subscribe_inbox(context, user=auto_user, maillist=auto_maillist).delay()
                    print s,
                    time.sleep(2)
                    print s.status
                except Exception as ex:
                    print ex.message
                    print name_ml, yt_subscriber
