#!/usr/bin/python
# encoding: utf-8

import sys
import os
import yenv

# --- /usr/lib/yandex/tools-maillists/src/maillists/manage.py

if yenv.type == 'development':
    sys.path = ['/home/fantasy/ml',
                '/home/fantasy/ml/src',
                '/home/fantasy/ml/src/maillists',
                '/etc/yandex/tools-maillists/celery/',
                ] + sys.path
else:
    sys.path = ['/etc/yandex/tools-maillists',
                '/usr/lib/yandex/tools-maillists/src',
                '/usr/lib/yandex/tools-maillists/src/maillists',
                '/etc/yandex/tools-maillists/celery/',
                ] + sys.path


os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

from mlcore.interaction.cmail_utils.create_maillist import create_request_context
from mlcore.tasks.low_level import (create_maillist_cmail, create_passport_user,
                       create_maillist_ml, create_maillist_ymail,
                       check_maillist_creation,
                       pdd_create_maillist, pdd_register_domain)
from mlcore.ml.models import CorporateDomain
from django.conf import settings
from mlcore.ml.models import MailList


def create_maillist_with_old_mx(context, data, user, use_cmail=False):
    """ Создаем рассылки. Не смотрим на MX, а сразу создаем в ПДД.
    Нужно для тестирования и создания старых рассылок с MX-ами mx-corp.yandex.ru"""
    full_data = create_request_context(data, user)

    chain = (create_passport_user.si(context, full_data) |
             create_maillist_ml.si(context, full_data) |
             create_maillist_ymail.si(context, full_data))

    if use_cmail:
        chain = (create_maillist_cmail.si(context, data, user) |
                 check_maillist_creation.si(context, full_data) |
                 chain)

    domain = CorporateDomain.objects.get(domain=full_data['domain'])

    if domain.domain not in settings.PASSPORT_ALIASES and domain.domain not in settings.YANDEX_TEAM_DOMAINS:
        # ML-1466: Завести рассылку в ПДД
        data = dict(domain=full_data['domain'], name=full_data['name'],
                    imap_email=full_data['imap_name'] + '@yandex-team.ru')
        chain |= (pdd_register_domain.si(context, domain=full_data['domain']) |
                  pdd_create_maillist.si(context, **data))

    return chain


def create_pdd_maillist(email):
    if '@' not in email:
        return
    name, domain = email.split('@')

    if domain in settings.PASSPORT_ALIASES or domain in settings.YANDEX_TEAM_DOMAINS:
        return

    if not MailList.objects.filter(email=email):
        return

    obj, _ = CorporateDomain.objects.get_or_create(domain=domain)
    obj.mx_type = CorporateDomain.MX_PDD
    obj.save()

    context = {
        'initiator': 'pdd_robot',
        'comment': 'create %s in pdd' % email,
    }
    m = MailList.objects.get(email=email)
    responsible = m.owner_set.all()[0] if m.owner_set.all() else set(['robot-yndx-maillists'])
    data = {
        'name': m.name,
        'responsible': m.owner_set.all(),
        'info': m.info,
        'info_en': m.info_en,
        'is_open': m.is_open,
        'is_internal': m.is_internal,
        'archive': m.is_archive,
        'before_clean': m.before_clean,
    }
    create_maillist_with_old_mx(context, data, responsible).delay()


if __name__ == "__main__":
    if len(sys.argv) == 2:
        emails = sys.argv[1]
        for email in emails.split(' ,;'):
            create_pdd_maillist(email.strip())
    else:
        print "Emails required"
