.PHONY: shell i18n pre_run run test

i18n:
	# используем свой tankerdownload_patched пока deb django_tanker не обновится до 0.12
	# $(MANAGE_PY) tankerdownload_patched --settings=$(TANKER_SETTINGS) Запускаем руками, т.к. SNI оторвало
	make compilemessages

$(LOG_DIR):
	mkdir $(LOG_DIR)

pre_run: $(LOG_DIR)

test: pre_run
	$(TEST_ALL_PY)

shell:
	$(MANAGE_PY) shell

shellplus:
	$(MANAGE_PY) shell_plus

runplus: pre_run
	$(MANAGE_PY) runserver_plus 0.0.0.0:$(DEV_PORT)

run: pre_run
	$(MANAGE_PY) runserver 0.0.0.0:$(DEV_PORT)

messages:
	cd $(LOCALE_PATH); django-admin.py makemessages -l en -l ru $(if $(MAKEMESSAGES_ARGS),$(MAKEMESSAGES_ARGS),)

tanker: messages
	$(MANAGE_PY) tankerupload --settings=$(TANKER_SETTINGS)

compilemessages:
	cd $(LOCALE_PATH); sed -i '/^#~/d' locale/*/LC_MESSAGES/*.po; django-admin.py compilemessages

migrate:
	$(MANAGE_PY) migrate --noinput


